﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FruitView : MonoBehaviour
{
    public GlassView m_glassView;
    public Glass1View m_glass1View;
    public Animator m_animator;
    public Transform m_fruitParent;
    public HighlightingEffect m_highLightEffect;
    public Transform m_cutTrans;//旋转叶片
    public float m_cutSpeed = 3.0f;//旋转速度
    private List<FruitItemView> m_selectLst = new List<FruitItemView>();//选中的水果
    private int m_lineIndex = 0;//线段计数
    private FruitItemView m_curSelectItem;//当前选中的
    private FruitItemView m_lastSelectItem;//上次选中的
    private bool m_bIsTouchUp = true;//是否松手
    private List<GameObject> m_lineLst = new List<GameObject>();
    private int m_SelectNum = 0;//选中数量
    private List<GameObject> m_fruitBombEffect = new List<GameObject>();//爆汁特效
    private List<GameObject> m_fruitDropEffect = new List<GameObject>();//流体特效
    private Color m_hightColor = new Color(217.0f / 255.0f, 233.0f / 255.0f, 1.0f, 1.0f);
    private int m_moveNum = 0;//移动次数
    private SpriteRenderer m_spriteRender;
    private void Awake()
    {
        if (m_animator)
        {
            m_spriteRender = m_animator.GetComponent<SpriteRenderer>();
            m_spriteRender.enabled = false;
        } 
    }
    void Start()
    {
        GameServices.inputService.pad.onTouchUp += OnTouchUp;
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            GlobalConfig.LoadFirstLevelDefaultFruit(m_fruitParent);
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex
            || BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelThreeIndex)
        {
            GlobalConfig.LoadSecondLevelDefaultFruit(m_fruitParent);
        }
        m_moveNum = GlobalConfig.FruitMoveTotalNum;
    }
    //是否正确三连
    bool IsConnectRight()
    {
        int varCount = m_selectLst.Count;
        if (varCount < 3)
        {
            return false;
        }
        int varStrawberryNum = 0;
        int varLemonNum = 0;
        int varOrangeNum = 0;
        for (int i = 0; i < varCount; i++)
        {
            if (m_selectLst[i].type == FruitType.Strawberry)
            {
                varStrawberryNum++;
            }
            else if (m_selectLst[i].type == FruitType.Lemon)
            {
                varLemonNum++;
            }
            else if (m_selectLst[i].type == FruitType.Orange)
            {
                varOrangeNum++;
            }
        }
        if(varCount == varStrawberryNum || varCount == varLemonNum || varCount == varOrangeNum)
        {
            return true;
        }
        return false;
    }
    // 抬起回调
    void OnTouchUp()
    {
        if(m_selectLst.Count <= 0)
        {
            return;
        }
        //水果变小重置
        m_bIsTouchUp = true;
        m_lastSelectItem = null;
        //线段回收
        //for (int i = 0; i < m_lineLst.Count; i++)
        //{
        //    PoolManager.Instance.ReturnObjectToPool(m_lineLst[i]);
        //}
        //m_lineLst.Clear();
        BattleCtrl.instance.battleUI.RecycleLine();
        //高亮重置
        for (int i = 0; i < m_selectLst.Count; i++)
        {
            HighlightableObject varHO = m_selectLst[i].GetComponent<HighlightableObject>();
            if (varHO)
            {
                varHO.FlashingOff();
            }
        }
        //水果刚体状态重置
        SetFruitRigidState(false);
        if (m_moveNum <= 0)
        {
            return;
        }
        if(m_selectLst.Count > 0)
        {
            m_moveNum--;
            BattleCtrl.instance.battleUI.SetMoveNum(m_moveNum);
            if(m_moveNum <= 0)
            {
                Invoke("DelayFail", 2.5f);
            }
        }
        //if(!IsConnectRight())
        //{
        //    m_selectLst.Clear();//重置下状态
        //    return;
        //}
        for (int i = 0; i < m_selectLst.Count; i++)
        {
            m_selectLst[i].SetFrag();
            //播放爆汁特效
            GameObject varEffectObj = null;
            int varRand = Random.Range(0, 2);
            if (m_selectLst[i].type == FruitType.Strawberry)
            {
                if (varRand == 0)
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StarwberryEffect1);
                }
                else
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StarwberryEffect2);
                }
            }
            else if (m_selectLst[i].type == FruitType.Lemon)
            {
                if (varRand == 0)
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonEffect1);
                }
                else
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonEffect2);
                }
            }
            else if(m_selectLst[i].type == FruitType.Orange)
            {
                if (varRand == 0)
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.OrangeEffect1);
                }
                else
                {
                    varEffectObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.OrangeEffect2);
                }
            }
            varEffectObj.transform.position = m_selectLst[i].transform.position;
            m_fruitBombEffect.Add(varEffectObj);
        }
        m_SelectNum = m_selectLst.Count;
        Invoke("DelayClear", 0.5f);
        Invoke("DelayClearEffect", 1.0f);
    }
    //延迟判断失败
    void DelayFail()
    {
        if(!BattleCtrl.instance.isEndBattle)
        {
            BattleCtrl.instance.OnBattleFail();
        }
    }
    //延迟删除特效
    void DelayClearEffect()
    {
        for (int i = 0; i < m_fruitBombEffect.Count; i++)
        {
            PoolManager.Instance.ReturnObjectToPool(m_fruitBombEffect[i]);
        }
        m_fruitBombEffect.Clear();
    }
    //延迟删除流体特效
    void DelayClearDropEffect()
    {
        for (int i = 0; i < m_fruitDropEffect.Count; i++)
        {
            PoolManager.Instance.ReturnObjectToPool(m_fruitDropEffect[i]);
        }
        m_fruitDropEffect.Clear();
    }
    //延迟删除
    void DelayClear()
    {
        int varStrawberryNum = 0;
        int varLemonNum = 0;
        int varOrangeNum = 0;
        for (int i = 0; i < m_selectLst.Count; i++)
        {
            if (m_selectLst[i].type == FruitType.Strawberry)
            {
                varStrawberryNum++;
            }
            else if(m_selectLst[i].type == FruitType.Lemon)
            {
                varLemonNum++;
            }
            else if(m_selectLst[i].type == FruitType.Orange)
            {
                varOrangeNum++;
            }
            PoolManager.Instance.ReturnObjectToPool(m_selectLst[i].gameObject);
            m_selectLst[i].ResetFragState();
        }
        if(m_glass1View)
        {
            m_glass1View.SetFruitNum(varStrawberryNum, varLemonNum, varOrangeNum);
        }
        if(m_glassView)
        {
            m_glassView.SetFruitNum(varStrawberryNum, varLemonNum, varOrangeNum);
        }
        m_selectLst.Clear();

        //流体特效
        //m_spriteRender.enabled = true;
        //if(varStrawberryNum > 0)
        //{
        //    if(varLemonNum > 0)
        //    {
        //        if(varOrangeNum > 0)
        //        {
        //            m_animator.Play("juice_red");
        //            GameServices.timerServices.Push(this, 0.5f, delegate
        //            {
        //                if (m_animator)
        //                {
        //                    m_animator.Play("juice_yellow");
        //                }
        //            });
        //            GameServices.timerServices.Push(this, 1.0f, delegate
        //            {
        //                if (m_animator)
        //                {
        //                    m_animator.Play("juice_Orange");
        //                }
        //            });
        //            GameServices.timerServices.Push(this, 1.5f, delegate
        //            {
        //                if (m_spriteRender)
        //                {
        //                    m_spriteRender.enabled = false;
        //                }
        //            });
        //        }
        //        else
        //        {
        //            m_animator.Play("juice_red");
        //            GameServices.timerServices.Push(this, 0.5f, delegate
        //            {
        //                if (m_animator)
        //                {
        //                    m_animator.Play("juice_yellow");
        //                }
        //            });
        //            GameServices.timerServices.Push(this, 1.0f, delegate
        //            {
        //                if (m_spriteRender)
        //                {
        //                    m_spriteRender.enabled = false;
        //                }
        //            });
        //        }
        //    }
        //    else
        //    {
        //        if (varOrangeNum > 0)
        //        {
        //            m_animator.Play("juice_red");
        //            GameServices.timerServices.Push(this, 0.5f, delegate
        //            {
        //                if (m_animator)
        //                {
        //                    m_animator.Play("juice_Orange");
        //                }
        //            });
        //            GameServices.timerServices.Push(this, 1.0f, delegate
        //            {
        //                if (m_spriteRender)
        //                {
        //                    m_spriteRender.enabled = false;
        //                }
        //            });
        //        }
        //        else
        //        {
        //            m_animator.Play("juice_red");
        //            GameServices.timerServices.Push(this, 0.5f, delegate
        //            {
        //                if (m_spriteRender)
        //                {
        //                    m_spriteRender.enabled = false;
        //                }
        //            });
        //        }
        //    }
        //}
        //else
        //{
        //    if (varLemonNum > 0)
        //    {
        //        if (varOrangeNum > 0)
        //        {
        //            m_animator.Play("juice_yellow");
        //            GameServices.timerServices.Push(this, 0.5f, delegate
        //            {
        //                if (m_animator)
        //                {
        //                    m_animator.Play("juice_Orange");
        //                }
        //            });
        //            GameServices.timerServices.Push(this, 1.0f, delegate
        //            {
        //                if (m_spriteRender)
        //                {
        //                    m_spriteRender.enabled = false;
        //                }
        //            });
        //        }
        //        else
        //        {
        //            m_animator.Play("juice_yellow");
        //            GameServices.timerServices.Push(this, 0.5f, delegate
        //            {
        //                if (m_spriteRender)
        //                {
        //                    m_spriteRender.enabled = false;
        //                }
        //            });
        //        }
        //    }
        //    else
        //    {
        //        if (varOrangeNum > 0)
        //        {
        //            m_animator.Play("juice_Orange");
        //            GameServices.timerServices.Push(this, 0.5f, delegate
        //            {
        //                if (m_spriteRender)
        //                {
        //                    m_spriteRender.enabled = false;
        //                }
        //            });
        //        }
        //    }
        //}
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex ||
        //    BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        //{
        //    if (varStrawberryNum > 0)
        //    {
        //        GameObject varEffect1 = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.StarwberryDropEffect);
        //        varEffect1.transform.position = m_glassView.effectPos;
        //        m_fruitDropEffect.Add(varEffect1);
        //    }
        //    if (varLemonNum > 0)
        //    {
        //        GameObject varEffect2 = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.LemonDropEffect);
        //        varEffect2.transform.position = m_glassView.effectPos;
        //        m_fruitDropEffect.Add(varEffect2);
        //    }
        //    if (varOrangeNum > 0)
        //    {
        //        GameObject varEffect3 = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.OrangeDropEffect);
        //        varEffect3.transform.position = m_glassView.effectPos;
        //        m_fruitDropEffect.Add(varEffect3);
        //    }
        //    Invoke("DelayClearDropEffect", 1.0f);
        //}
        Invoke("DelayCreate", 0.2f);
    }
    //播放流体
    public void ShowAnimator(string str)
    {
        m_spriteRender.enabled = true;
        m_animator.Play(str);
    }
    //隐藏流体
    public void HideAnimator()
    {
        m_spriteRender.enabled = false;
    }
    //延迟生成
    void DelayCreate()
    {
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            GlobalConfig.LoadFirstRandomFruit(m_SelectNum, m_fruitParent);
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex
            || BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelThreeIndex)
        {
            GlobalConfig.LoadSecondRandomFruit(m_SelectNum, m_fruitParent);
        }
    }
    //refresh
    public void Refresh()
    {
        //Rigidbody[] varBody = m_fruitParent.GetComponentsInChildren<Rigidbody>();
        //for(int i = 0;i<varBody.Length;i++)
        //{
        //    Transform varTrans = varBody[i].transform;
        //    if(varBody[i].transform.localPosition.x < 0)
        //    {
        //        varBody[i].AddForce((Vector3.up + Vector3.right) * 3.0f, ForceMode.Impulse);
        //    }
        //    else
        //    {
        //        varBody[i].AddForce((Vector3.left) * 3.0f, ForceMode.Impulse);
        //    }
        //}
        Transform varStrawberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.StrawberryObj);
        if (varStrawberry)
        {
            Rigidbody[] varBody = varStrawberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                Transform varTrans = varBody[i].transform;
                if (varBody[i].transform.position.x < 0)
                {
                    varBody[i].AddForce((Vector3.up + Vector3.right) * 3.0f, ForceMode.Impulse);
                }
                else
                {
                    varBody[i].AddForce((Vector3.left) * 3.0f, ForceMode.Impulse);
                }
            }
        }
        Transform varLemonberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.LemonObj);
        if (varLemonberry)
        {
            Rigidbody[] varBody = varLemonberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                Transform varTrans = varBody[i].transform;
                if (varBody[i].transform.position.x < 0)
                {
                    varBody[i].AddForce((Vector3.up + Vector3.right) * 3.0f, ForceMode.Impulse);
                }
                else
                {
                    varBody[i].AddForce((Vector3.left) * 3.0f, ForceMode.Impulse);
                }
            }
        }
        Transform varOrangeberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.OrangeObj);
        if (varOrangeberry)
        {
            Rigidbody[] varBody = varOrangeberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                Transform varTrans = varBody[i].transform;
                if (varBody[i].transform.position.x < 0)
                {
                    varBody[i].AddForce((Vector3.up + Vector3.right) * 3.0f, ForceMode.Impulse);
                }
                else
                {
                    varBody[i].AddForce((Vector3.left) * 3.0f, ForceMode.Impulse);
                }
            }
        }
    }
    // Update is called once per frame
    void Update()
    {
        UpdateCutRotate();
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle || m_moveNum == 0)
        {
            return;
        }
        if (Input.GetMouseButton(0))
        {
            Clicked();
        }
        UpdateSelectSize();
    }
    //旋转叶片
    void UpdateCutRotate()
    {
        if(m_cutTrans)
        {
            m_cutTrans.Rotate(transform.up* m_cutSpeed, Space.Self);
        }
    }
    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit,100.0f,2))
        {
            if (hit.collider && hit.collider.gameObject.CompareTag("Target"))
            {
                FruitItemView varHitTrans = hit.collider.transform.GetComponent<FruitItemView>();
                if (!m_selectLst.Contains(varHitTrans))
                {
                    m_bIsTouchUp = false;
                    SetFruitRigidState(true);
                    m_highLightEffect.enabled = false;
                    m_highLightEffect.enabled = true;
                    HighlightableObject varHo = hit.collider.GetComponent<HighlightableObject>();
                    if (varHo)
                    {
                        varHo.FlashingOn(Color.magenta, Color.magenta, 1.0f);// Color.magenta
                    }
                    m_curSelectItem = varHitTrans;
                    if (m_selectLst.Count > 0)
                    {
                        m_lastSelectItem = m_selectLst[m_selectLst.Count - 1];
                    }
                    if(m_lastSelectItem)
                    {
                        Vector3 varVec3Last = Camera.main.WorldToScreenPoint(m_lastSelectItem.transform.position);

                        Vector3 varVec3Cur = Camera.main.WorldToScreenPoint(m_curSelectItem.transform.position);
                        BattleCtrl.instance.battleUI.DrawLine(varVec3Last, varVec3Cur);
                        //DrawLS(m_lastSelectItem.transform, m_curSelectItem.transform);
                    }
                    m_selectLst.Add(varHitTrans);
                }
            }
        }
    }
    //选中物体大小变化
    void UpdateSelectSize()
    {
        if (m_curSelectItem)
        {
            if (m_bIsTouchUp)
            {
                m_curSelectItem.SetChangeSmall();
            }
            else
            {
                m_curSelectItem.SetChangeBig();
            }
        }
        if (m_lastSelectItem)
        {
            m_lastSelectItem.SetChangeSmall();
        }
    }
    //线段渲染
    //void ShowLine(Transform trans)
    //{
    //    lineRenderer.positionCount = m_lineIndex + 1;
    //    lineRenderer.SetPosition(m_lineIndex, trans.position);
    //    m_lineIndex++;
    //}

    void DrawLS(Transform startP, Transform finalP)
    {
        Vector3 varStart = startP.position;
        //varStart.z = 0;
        Vector3 varFinal = finalP.position;
        //varFinal.z = 0;
        Vector3 rightPosition = (varStart + varFinal) / 2;
        Vector3 rightRotation = varFinal - varStart;
        float HalfLength = Vector3.Distance(varStart, varFinal) / 2;
        float LThickness = 0.02f;//线的粗细

        //创建圆柱体
        GameObject MyLine = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.lineObj);
        rightPosition.z = -2.0f;
        MyLine.transform.position = rightPosition;
        MyLine.transform.rotation = Quaternion.FromToRotation(Vector3.up, rightRotation);
        MyLine.transform.localScale = new Vector3(LThickness, HalfLength, LThickness);
        m_lineLst.Add(MyLine);

        //这里可以设置材质，具体自己设置
        //MyLine.GetComponent<MeshRenderer>().material = GetComponent<MeshRenderer>().material;
    }
    //设置水果刚体状态
    void SetFruitRigidState(bool value)
    {
        Transform varStrawberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.StrawberryObj);
        if (varStrawberry)
        {
            Rigidbody[] varBody = varStrawberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                varBody[i].isKinematic = value;
            }
        }
        Transform varLemonberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.LemonObj);
        if (varLemonberry)
        {
            Rigidbody[] varBody = varLemonberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                varBody[i].isKinematic = value;
            }
        }
        Transform varOrangeberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.OrangeObj);
        if (varOrangeberry)
        {
            Rigidbody[] varBody = varOrangeberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                varBody[i].isKinematic = value;
            }
        }
    }
    //缓存所有水果
    public void CacheAllFruit()
    {
        Transform varStrawberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.StrawberryObj);
        if(varStrawberry)
        {
            Rigidbody[] varBody = varStrawberry.GetComponentsInChildren<Rigidbody>();
            for(int i = 0;i<varBody.Length;i++)
            {
                PoolManager.Instance.ReturnObjectToPool(varBody[i].gameObject);
            }
        }
        Transform varLemonberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.LemonObj);
        if (varLemonberry)
        {
            Rigidbody[] varBody = varLemonberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                PoolManager.Instance.ReturnObjectToPool(varBody[i].gameObject);
            }
        }
        Transform varOrangeberry = PoolManager.Instance.GetObjectRoot(CacheManager.Instance.OrangeObj);
        if (varOrangeberry)
        {
            Rigidbody[] varBody = varOrangeberry.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < varBody.Length; i++)
            {
                PoolManager.Instance.ReturnObjectToPool(varBody[i].gameObject);
            }
        }
    }
    //-------------------------------------GL画线--------------------------------------
    private bool beginDraw = false;
    private Vector3 curPos = Vector3.zero;
    private float interval = 0.1f;
    private List<Vector3> posList = new List<Vector3>();
    //public Material lineMaterial;
    void sOnGUI()
    {
        Event e = Event.current;

        if (e != null/* && e.type != null*/)
        {
            if (e.type == EventType.MouseDown)
            {
                beginDraw = true;
            }
            if (e.type == EventType.MouseDrag)
            {

                if (Vector3.Distance(curPos, Input.mousePosition) > interval)
                {
                    curPos = Input.mousePosition;

                    posList.Add(new Vector3(curPos.x / Screen.width, curPos.y / Screen.height, 0));
                }
            }
            if (e.type == EventType.MouseUp)
            {
                beginDraw = false;
                ClearLines();
            }
        }
        DrawLine();
    }

    void ClearLines()
    {
        beginDraw = false;
        posList.Clear();
        curPos = Vector3.zero;
        GL.PushMatrix();
        GL.Clear(true, true, Color.white);
        GL.PopMatrix();

    }
    void DrawLine()
    {
        if (!beginDraw)
            return;
        GL.PushMatrix();
        GL.LoadOrtho();

        //lineMaterial.SetPass(0);
        GL.Begin(GL.QUADS);
        for (int i = 0; i < posList.Count - 1; i++)
        {
            Vector3 pos = posList[i];
            GL.Vertex3(pos.x, pos.y, pos.z);
            GL.Vertex3(posList[i + 1].x, posList[i + 1].y, posList[i + 1].z);
        }

        GL.End();
        GL.PopMatrix();
    }
    //-------------------------------------GL画线--------------------------------------
    private void OnDestroy()
    {
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onTouchUp -= OnTouchUp;
        }
        m_lineLst.Clear();
        m_lineLst = null;
        m_selectLst.Clear();
        m_selectLst = null;
        DelayClearEffect();
        DelayClearDropEffect();
        //m_fruitBombEffect.Clear();
        m_fruitBombEffect = null;
        //m_fruitDropEffect.Clear();
        m_fruitDropEffect = null;
        SetFruitRigidState(false);
    }
}
